/*
 * language_data.js
 * ~~~~~~~~~~~~~~~~
 *
 * This script contains the language-specific data used by searchtools.js,
 * namely the list of stopwords, stemmer, scorer and splitter.
 *
 * :copyright: Copyright 2007-2022 by the Sphinx team, see AUTHORS.
 * :license: BSD, see LICENSE for details.
 *
 */

var stopwords = ["ei", "eiv\u00e4t", "emme", "en", "et", "ette", "ett\u00e4", "he", "heid\u00e4n", "heid\u00e4t", "heihin", "heille", "heill\u00e4", "heilt\u00e4", "heiss\u00e4", "heist\u00e4", "heit\u00e4", "h\u00e4n", "h\u00e4neen", "h\u00e4nelle", "h\u00e4nell\u00e4", "h\u00e4nelt\u00e4", "h\u00e4nen", "h\u00e4ness\u00e4", "h\u00e4nest\u00e4", "h\u00e4net", "h\u00e4nt\u00e4", "itse", "ja", "johon", "joiden", "joihin", "joiksi", "joilla", "joille", "joilta", "joina", "joissa", "joista", "joita", "joka", "joksi", "jolla", "jolle", "jolta", "jona", "jonka", "jos", "jossa", "josta", "jota", "jotka", "kanssa", "keiden", "keihin", "keiksi", "keille", "keill\u00e4", "keilt\u00e4", "kein\u00e4", "keiss\u00e4", "keist\u00e4", "keit\u00e4", "keneen", "keneksi", "kenelle", "kenell\u00e4", "kenelt\u00e4", "kenen", "kenen\u00e4", "keness\u00e4", "kenest\u00e4", "kenet", "ketk\u00e4", "ket\u00e4", "koska", "kuin", "kuka", "kun", "me", "meid\u00e4n", "meid\u00e4t", "meihin", "meille", "meill\u00e4", "meilt\u00e4", "meiss\u00e4", "meist\u00e4", "meit\u00e4", "mihin", "miksi", "mik\u00e4", "mille", "mill\u00e4", "milt\u00e4", "mink\u00e4", "minua", "minulla", "minulle", "minulta", "minun", "minussa", "minusta", "minut", "minuun", "min\u00e4", "miss\u00e4", "mist\u00e4", "mitk\u00e4", "mit\u00e4", "mukaan", "mutta", "ne", "niiden", "niihin", "niiksi", "niille", "niill\u00e4", "niilt\u00e4", "niin", "niin\u00e4", "niiss\u00e4", "niist\u00e4", "niit\u00e4", "noiden", "noihin", "noiksi", "noilla", "noille", "noilta", "noin", "noina", "noissa", "noista", "noita", "nuo", "nyt", "n\u00e4iden", "n\u00e4ihin", "n\u00e4iksi", "n\u00e4ille", "n\u00e4ill\u00e4", "n\u00e4ilt\u00e4", "n\u00e4in\u00e4", "n\u00e4iss\u00e4", "n\u00e4ist\u00e4", "n\u00e4it\u00e4", "n\u00e4m\u00e4", "ole", "olemme", "olen", "olet", "olette", "oli", "olimme", "olin", "olisi", "olisimme", "olisin", "olisit", "olisitte", "olisivat", "olit", "olitte", "olivat", "olla", "olleet", "ollut", "on", "ovat", "poikki", "se", "sek\u00e4", "sen", "siihen", "siin\u00e4", "siit\u00e4", "siksi", "sille", "sill\u00e4", "silt\u00e4", "sinua", "sinulla", "sinulle", "sinulta", "sinun", "sinussa", "sinusta", "sinut", "sinuun", "sin\u00e4", "sit\u00e4", "tai", "te", "teid\u00e4n", "teid\u00e4t", "teihin", "teille", "teill\u00e4", "teilt\u00e4", "teiss\u00e4", "teist\u00e4", "teit\u00e4", "tuo", "tuohon", "tuoksi", "tuolla", "tuolle", "tuolta", "tuon", "tuona", "tuossa", "tuosta", "tuota", "t\u00e4h\u00e4n", "t\u00e4ksi", "t\u00e4lle", "t\u00e4ll\u00e4", "t\u00e4lt\u00e4", "t\u00e4m\u00e4", "t\u00e4m\u00e4n", "t\u00e4n\u00e4", "t\u00e4ss\u00e4", "t\u00e4st\u00e4", "t\u00e4t\u00e4", "vaan", "vai", "vaikka", "yli"];


/* Non-minified version is copied as a separate JS file, is available */
BaseStemmer=function(){this.setCurrent=function(r){this.current=r;this.cursor=0;this.limit=this.current.length;this.limit_backward=0;this.bra=this.cursor;this.ket=this.limit};this.getCurrent=function(){return this.current};this.copy_from=function(r){this.current=r.current;this.cursor=r.cursor;this.limit=r.limit;this.limit_backward=r.limit_backward;this.bra=r.bra;this.ket=r.ket};this.in_grouping=function(r,t,i){if(this.cursor>=this.limit)return false;var s=this.current.charCodeAt(this.cursor);if(s>i||s<t)return false;s-=t;if((r[s>>>3]&1<<(s&7))==0)return false;this.cursor++;return true};this.in_grouping_b=function(r,t,i){if(this.cursor<=this.limit_backward)return false;var s=this.current.charCodeAt(this.cursor-1);if(s>i||s<t)return false;s-=t;if((r[s>>>3]&1<<(s&7))==0)return false;this.cursor--;return true};this.out_grouping=function(r,t,i){if(this.cursor>=this.limit)return false;var s=this.current.charCodeAt(this.cursor);if(s>i||s<t){this.cursor++;return true}s-=t;if((r[s>>>3]&1<<(s&7))==0){this.cursor++;return true}return false};this.out_grouping_b=function(r,t,i){if(this.cursor<=this.limit_backward)return false;var s=this.current.charCodeAt(this.cursor-1);if(s>i||s<t){this.cursor--;return true}s-=t;if((r[s>>>3]&1<<(s&7))==0){this.cursor--;return true}return false};this.eq_s=function(r){if(this.limit-this.cursor<r.length)return false;if(this.current.slice(this.cursor,this.cursor+r.length)!=r){return false}this.cursor+=r.length;return true};this.eq_s_b=function(r){if(this.cursor-this.limit_backward<r.length)return false;if(this.current.slice(this.cursor-r.length,this.cursor)!=r){return false}this.cursor-=r.length;return true};this.find_among=function(r){var t=0;var i=r.length;var s=this.cursor;var e=this.limit;var h=0;var u=0;var n=false;while(true){var c=t+(i-t>>>1);var a=0;var f=h<u?h:u;var l=r[c];var o;for(o=f;o<l[0].length;o++){if(s+f==e){a=-1;break}a=this.current.charCodeAt(s+f)-l[0].charCodeAt(o);if(a!=0)break;f++}if(a<0){i=c;u=f}else{t=c;h=f}if(i-t<=1){if(t>0)break;if(i==t)break;if(n)break;n=true}}do{var l=r[t];if(h>=l[0].length){this.cursor=s+l[0].length;if(l.length<4)return l[2];var v=l[3](this);this.cursor=s+l[0].length;if(v)return l[2]}t=l[1]}while(t>=0);return 0};this.find_among_b=function(r){var t=0;var i=r.length;var s=this.cursor;var e=this.limit_backward;var h=0;var u=0;var n=false;while(true){var c=t+(i-t>>1);var a=0;var f=h<u?h:u;var l=r[c];var o;for(o=l[0].length-1-f;o>=0;o--){if(s-f==e){a=-1;break}a=this.current.charCodeAt(s-1-f)-l[0].charCodeAt(o);if(a!=0)break;f++}if(a<0){i=c;u=f}else{t=c;h=f}if(i-t<=1){if(t>0)break;if(i==t)break;if(n)break;n=true}}do{var l=r[t];if(h>=l[0].length){this.cursor=s-l[0].length;if(l.length<4)return l[2];var v=l[3](this);this.cursor=s-l[0].length;if(v)return l[2]}t=l[1]}while(t>=0);return 0};this.replace_s=function(r,t,i){var s=i.length-(t-r);this.current=this.current.slice(0,r)+i+this.current.slice(t);this.limit+=s;if(this.cursor>=t)this.cursor+=s;else if(this.cursor>r)this.cursor=r;return s};this.slice_check=function(){if(this.bra<0||this.bra>this.ket||this.ket>this.limit||this.limit>this.current.length){return false}return true};this.slice_from=function(r){var t=false;if(this.slice_check()){this.replace_s(this.bra,this.ket,r);t=true}return t};this.slice_del=function(){return this.slice_from("")};this.insert=function(r,t,i){var s=this.replace_s(r,t,i);if(r<=this.bra)this.bra+=s;if(r<=this.ket)this.ket+=s};this.slice_to=function(){var r="";if(this.slice_check()){r=this.current.slice(this.bra,this.ket)}return r};this.assign_to=function(){return this.current.slice(0,this.limit)}};
FinnishStemmer=function(){var r=new BaseStemmer;var i=[["pa",-1,1],["sti",-1,2],["kaan",-1,1],["han",-1,1],["kin",-1,1],["hän",-1,1],["kään",-1,1],["ko",-1,1],["pä",-1,1],["kö",-1,1]];var e=[["lla",-1,-1],["na",-1,-1],["ssa",-1,-1],["ta",-1,-1],["lta",3,-1],["sta",3,-1]];var a=[["llä",-1,-1],["nä",-1,-1],["ssä",-1,-1],["tä",-1,-1],["ltä",3,-1],["stä",3,-1]];var s=[["lle",-1,-1],["ine",-1,-1]];var t=[["nsa",-1,3],["mme",-1,3],["nne",-1,3],["ni",-1,2],["si",-1,1],["an",-1,4],["en",-1,6],["än",-1,5],["nsä",-1,3]];var u=[["aa",-1,-1],["ee",-1,-1],["ii",-1,-1],["oo",-1,-1],["uu",-1,-1],["ää",-1,-1],["öö",-1,-1]];var l=[["a",-1,8],["lla",0,-1],["na",0,-1],["ssa",0,-1],["ta",0,-1],["lta",4,-1],["sta",4,-1],["tta",4,2],["lle",-1,-1],["ine",-1,-1],["ksi",-1,-1],["n",-1,7],["han",11,1],["den",11,-1,S],["seen",11,-1,C],["hen",11,2],["tten",11,-1,S],["hin",11,3],["siin",11,-1,S],["hon",11,4],["hän",11,5],["hön",11,6],["ä",-1,8],["llä",22,-1],["nä",22,-1],["ssä",22,-1],["tä",22,-1],["ltä",26,-1],["stä",26,-1],["ttä",26,2]];var c=[["eja",-1,-1],["mma",-1,1],["imma",1,-1],["mpa",-1,1],["impa",3,-1],["mmi",-1,1],["immi",5,-1],["mpi",-1,1],["impi",7,-1],["ejä",-1,-1],["mmä",-1,1],["immä",10,-1],["mpä",-1,1],["impä",12,-1]];var n=[["i",-1,-1],["j",-1,-1]];var f=[["mma",-1,1],["imma",0,-1]];var o=[17,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8];var b=[119,223,119,1];var _=[17,65,16,1,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32];var m=[17,65,16,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32];var k=[17,97,24,1,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32];var d=false;var v="";var w=0;var g=0;function p(){g=r.limit;w=r.limit;r:while(true){var i=r.cursor;i:{if(!r.in_grouping(_,97,246)){break i}r.cursor=i;break r}r.cursor=i;if(r.cursor>=r.limit){return false}r.cursor++}r:while(true){i:{if(!r.out_grouping(_,97,246)){break i}break r}if(r.cursor>=r.limit){return false}r.cursor++}g=r.cursor;r:while(true){var e=r.cursor;i:{if(!r.in_grouping(_,97,246)){break i}r.cursor=e;break r}r.cursor=e;if(r.cursor>=r.limit){return false}r.cursor++}r:while(true){i:{if(!r.out_grouping(_,97,246)){break i}break r}if(r.cursor>=r.limit){return false}r.cursor++}w=r.cursor;return true}function h(){if(!(w<=r.cursor)){return false}return true}function q(){var e;if(r.cursor<g){return false}var a=r.limit_backward;r.limit_backward=g;r.ket=r.cursor;e=r.find_among_b(i);if(e==0){r.limit_backward=a;return false}r.bra=r.cursor;r.limit_backward=a;switch(e){case 1:if(!r.in_grouping_b(k,97,246)){return false}break;case 2:if(!h()){return false}break}if(!r.slice_del()){return false}return true}function j(){var i;if(r.cursor<g){return false}var u=r.limit_backward;r.limit_backward=g;r.ket=r.cursor;i=r.find_among_b(t);if(i==0){r.limit_backward=u;return false}r.bra=r.cursor;r.limit_backward=u;switch(i){case 1:{var l=r.limit-r.cursor;r:{if(!r.eq_s_b("k")){break r}return false}r.cursor=r.limit-l}if(!r.slice_del()){return false}break;case 2:if(!r.slice_del()){return false}r.ket=r.cursor;if(!r.eq_s_b("kse")){return false}r.bra=r.cursor;if(!r.slice_from("ksi")){return false}break;case 3:if(!r.slice_del()){return false}break;case 4:if(r.find_among_b(e)==0){return false}if(!r.slice_del()){return false}break;case 5:if(r.find_among_b(a)==0){return false}if(!r.slice_del()){return false}break;case 6:if(r.find_among_b(s)==0){return false}if(!r.slice_del()){return false}break}return true}function C(){if(r.find_among_b(u)==0){return false}return true}function S(){if(!r.eq_s_b("i")){return false}if(!r.in_grouping_b(m,97,246)){return false}return true}function B(){var i;if(r.cursor<g){return false}var e=r.limit_backward;r.limit_backward=g;r.ket=r.cursor;i=r.find_among_b(l);if(i==0){r.limit_backward=e;return false}r.bra=r.cursor;r.limit_backward=e;switch(i){case 1:if(!r.eq_s_b("a")){return false}break;case 2:if(!r.eq_s_b("e")){return false}break;case 3:if(!r.eq_s_b("i")){return false}break;case 4:if(!r.eq_s_b("o")){return false}break;case 5:if(!r.eq_s_b("ä")){return false}break;case 6:if(!r.eq_s_b("ö")){return false}break;case 7:var a=r.limit-r.cursor;r:{var s=r.limit-r.cursor;i:{var t=r.limit-r.cursor;e:{if(!C()){break e}break i}r.cursor=r.limit-t;if(!r.eq_s_b("ie")){r.cursor=r.limit-a;break r}}r.cursor=r.limit-s;if(r.cursor<=r.limit_backward){r.cursor=r.limit-a;break r}r.cursor--;r.bra=r.cursor}break;case 8:if(!r.in_grouping_b(_,97,246)){return false}if(!r.in_grouping_b(b,98,122)){return false}break}if(!r.slice_del()){return false}d=true;return true}function F(){var i;if(r.cursor<w){return false}var e=r.limit_backward;r.limit_backward=w;r.ket=r.cursor;i=r.find_among_b(c);if(i==0){r.limit_backward=e;return false}r.bra=r.cursor;r.limit_backward=e;switch(i){case 1:{var a=r.limit-r.cursor;r:{if(!r.eq_s_b("po")){break r}return false}r.cursor=r.limit-a}break}if(!r.slice_del()){return false}return true}function W(){if(r.cursor<g){return false}var i=r.limit_backward;r.limit_backward=g;r.ket=r.cursor;if(r.find_among_b(n)==0){r.limit_backward=i;return false}r.bra=r.cursor;r.limit_backward=i;if(!r.slice_del()){return false}return true}function x(){var i;if(r.cursor<g){return false}var e=r.limit_backward;r.limit_backward=g;r.ket=r.cursor;if(!r.eq_s_b("t")){r.limit_backward=e;return false}r.bra=r.cursor;var a=r.limit-r.cursor;if(!r.in_grouping_b(_,97,246)){r.limit_backward=e;return false}r.cursor=r.limit-a;if(!r.slice_del()){return false}r.limit_backward=e;if(r.cursor<w){return false}var s=r.limit_backward;r.limit_backward=w;r.ket=r.cursor;i=r.find_among_b(f);if(i==0){r.limit_backward=s;return false}r.bra=r.cursor;r.limit_backward=s;switch(i){case 1:{var t=r.limit-r.cursor;r:{if(!r.eq_s_b("po")){break r}return false}r.cursor=r.limit-t}break}if(!r.slice_del()){return false}return true}function y(){if(r.cursor<g){return false}var i=r.limit_backward;r.limit_backward=g;var e=r.limit-r.cursor;r:{var a=r.limit-r.cursor;if(!C()){break r}r.cursor=r.limit-a;r.ket=r.cursor;if(r.cursor<=r.limit_backward){break r}r.cursor--;r.bra=r.cursor;if(!r.slice_del()){return false}}r.cursor=r.limit-e;var s=r.limit-r.cursor;r:{r.ket=r.cursor;if(!r.in_grouping_b(o,97,228)){break r}r.bra=r.cursor;if(!r.in_grouping_b(b,98,122)){break r}if(!r.slice_del()){return false}}r.cursor=r.limit-s;var t=r.limit-r.cursor;r:{r.ket=r.cursor;if(!r.eq_s_b("j")){break r}r.bra=r.cursor;i:{var u=r.limit-r.cursor;e:{if(!r.eq_s_b("o")){break e}break i}r.cursor=r.limit-u;if(!r.eq_s_b("u")){break r}}if(!r.slice_del()){return false}}r.cursor=r.limit-t;var l=r.limit-r.cursor;r:{r.ket=r.cursor;if(!r.eq_s_b("o")){break r}r.bra=r.cursor;if(!r.eq_s_b("j")){break r}if(!r.slice_del()){return false}}r.cursor=r.limit-l;r.limit_backward=i;r:while(true){var c=r.limit-r.cursor;i:{if(!r.out_grouping_b(_,97,246)){break i}r.cursor=r.limit-c;break r}r.cursor=r.limit-c;if(r.cursor<=r.limit_backward){return false}r.cursor--}r.ket=r.cursor;if(!r.in_grouping_b(b,98,122)){return false}r.bra=r.cursor;v=r.slice_to();if(v==""){return false}if(!r.eq_s_b(v)){return false}if(!r.slice_del()){return false}return true}this.stem=function(){var i=r.cursor;p();r.cursor=i;d=false;r.limit_backward=r.cursor;r.cursor=r.limit;var e=r.limit-r.cursor;q();r.cursor=r.limit-e;var a=r.limit-r.cursor;j();r.cursor=r.limit-a;var s=r.limit-r.cursor;B();r.cursor=r.limit-s;var t=r.limit-r.cursor;F();r.cursor=r.limit-t;r:{i:{if(!d){break i}var u=r.limit-r.cursor;W();r.cursor=r.limit-u;break r}var l=r.limit-r.cursor;x();r.cursor=r.limit-l}var c=r.limit-r.cursor;y();r.cursor=r.limit-c;r.cursor=r.limit_backward;return true};this["stemWord"]=function(i){r.setCurrent(i);this.stem();return r.getCurrent()}};
Stemmer = FinnishStemmer;
