/*
 * language_data.js
 * ~~~~~~~~~~~~~~~~
 *
 * This script contains the language-specific data used by searchtools.js,
 * namely the list of stopwords, stemmer, scorer and splitter.
 *
 * :copyright: Copyright 2007-2022 by the Sphinx team, see AUTHORS.
 * :license: BSD, see LICENSE for details.
 *
 */

var stopwords = ["alla", "allt", "att", "av", "blev", "bli", "blir", "blivit", "de", "dem", "den", "denna", "deras", "dess", "dessa", "det", "detta", "dig", "din", "dina", "ditt", "du", "d\u00e4r", "d\u00e5", "efter", "ej", "eller", "en", "er", "era", "ert", "ett", "fr\u00e5n", "f\u00f6r", "ha", "hade", "han", "hans", "har", "henne", "hennes", "hon", "honom", "hur", "h\u00e4r", "i", "icke", "ingen", "inom", "inte", "jag", "ju", "kan", "kunde", "man", "med", "mellan", "men", "mig", "min", "mina", "mitt", "mot", "mycket", "ni", "nu", "n\u00e4r", "n\u00e5gon", "n\u00e5got", "n\u00e5gra", "och", "om", "oss", "p\u00e5", "samma", "sedan", "sig", "sin", "sina", "sitta", "sj\u00e4lv", "skulle", "som", "s\u00e5", "s\u00e5dan", "s\u00e5dana", "s\u00e5dant", "till", "under", "upp", "ut", "utan", "vad", "var", "vara", "varf\u00f6r", "varit", "varje", "vars", "vart", "vem", "vi", "vid", "vilka", "vilkas", "vilken", "vilket", "v\u00e5r", "v\u00e5ra", "v\u00e5rt", "\u00e4n", "\u00e4r", "\u00e5t", "\u00f6ver"];


/* Non-minified version is copied as a separate JS file, is available */
BaseStemmer=function(){this.setCurrent=function(r){this.current=r;this.cursor=0;this.limit=this.current.length;this.limit_backward=0;this.bra=this.cursor;this.ket=this.limit};this.getCurrent=function(){return this.current};this.copy_from=function(r){this.current=r.current;this.cursor=r.cursor;this.limit=r.limit;this.limit_backward=r.limit_backward;this.bra=r.bra;this.ket=r.ket};this.in_grouping=function(r,t,i){if(this.cursor>=this.limit)return false;var s=this.current.charCodeAt(this.cursor);if(s>i||s<t)return false;s-=t;if((r[s>>>3]&1<<(s&7))==0)return false;this.cursor++;return true};this.in_grouping_b=function(r,t,i){if(this.cursor<=this.limit_backward)return false;var s=this.current.charCodeAt(this.cursor-1);if(s>i||s<t)return false;s-=t;if((r[s>>>3]&1<<(s&7))==0)return false;this.cursor--;return true};this.out_grouping=function(r,t,i){if(this.cursor>=this.limit)return false;var s=this.current.charCodeAt(this.cursor);if(s>i||s<t){this.cursor++;return true}s-=t;if((r[s>>>3]&1<<(s&7))==0){this.cursor++;return true}return false};this.out_grouping_b=function(r,t,i){if(this.cursor<=this.limit_backward)return false;var s=this.current.charCodeAt(this.cursor-1);if(s>i||s<t){this.cursor--;return true}s-=t;if((r[s>>>3]&1<<(s&7))==0){this.cursor--;return true}return false};this.eq_s=function(r){if(this.limit-this.cursor<r.length)return false;if(this.current.slice(this.cursor,this.cursor+r.length)!=r){return false}this.cursor+=r.length;return true};this.eq_s_b=function(r){if(this.cursor-this.limit_backward<r.length)return false;if(this.current.slice(this.cursor-r.length,this.cursor)!=r){return false}this.cursor-=r.length;return true};this.find_among=function(r){var t=0;var i=r.length;var s=this.cursor;var e=this.limit;var h=0;var u=0;var n=false;while(true){var c=t+(i-t>>>1);var a=0;var f=h<u?h:u;var l=r[c];var o;for(o=f;o<l[0].length;o++){if(s+f==e){a=-1;break}a=this.current.charCodeAt(s+f)-l[0].charCodeAt(o);if(a!=0)break;f++}if(a<0){i=c;u=f}else{t=c;h=f}if(i-t<=1){if(t>0)break;if(i==t)break;if(n)break;n=true}}do{var l=r[t];if(h>=l[0].length){this.cursor=s+l[0].length;if(l.length<4)return l[2];var v=l[3](this);this.cursor=s+l[0].length;if(v)return l[2]}t=l[1]}while(t>=0);return 0};this.find_among_b=function(r){var t=0;var i=r.length;var s=this.cursor;var e=this.limit_backward;var h=0;var u=0;var n=false;while(true){var c=t+(i-t>>1);var a=0;var f=h<u?h:u;var l=r[c];var o;for(o=l[0].length-1-f;o>=0;o--){if(s-f==e){a=-1;break}a=this.current.charCodeAt(s-1-f)-l[0].charCodeAt(o);if(a!=0)break;f++}if(a<0){i=c;u=f}else{t=c;h=f}if(i-t<=1){if(t>0)break;if(i==t)break;if(n)break;n=true}}do{var l=r[t];if(h>=l[0].length){this.cursor=s-l[0].length;if(l.length<4)return l[2];var v=l[3](this);this.cursor=s-l[0].length;if(v)return l[2]}t=l[1]}while(t>=0);return 0};this.replace_s=function(r,t,i){var s=i.length-(t-r);this.current=this.current.slice(0,r)+i+this.current.slice(t);this.limit+=s;if(this.cursor>=t)this.cursor+=s;else if(this.cursor>r)this.cursor=r;return s};this.slice_check=function(){if(this.bra<0||this.bra>this.ket||this.ket>this.limit||this.limit>this.current.length){return false}return true};this.slice_from=function(r){var t=false;if(this.slice_check()){this.replace_s(this.bra,this.ket,r);t=true}return t};this.slice_del=function(){return this.slice_from("")};this.insert=function(r,t,i){var s=this.replace_s(r,t,i);if(r<=this.bra)this.bra+=s;if(r<=this.ket)this.ket+=s};this.slice_to=function(){var r="";if(this.slice_check()){r=this.current.slice(this.bra,this.ket)}return r};this.assign_to=function(){return this.current.slice(0,this.limit)}};
SwedishStemmer=function(){var r=new BaseStemmer;var e=[["a",-1,1],["arna",0,1],["erna",0,1],["heterna",2,1],["orna",0,1],["ad",-1,1],["e",-1,1],["ade",6,1],["ande",6,1],["arne",6,1],["are",6,1],["aste",6,1],["en",-1,1],["anden",12,1],["aren",12,1],["heten",12,1],["ern",-1,1],["ar",-1,1],["er",-1,1],["heter",18,1],["or",-1,1],["s",-1,2],["as",21,1],["arnas",22,1],["ernas",22,1],["ornas",22,1],["es",21,1],["ades",26,1],["andes",26,1],["ens",21,1],["arens",29,1],["hetens",29,1],["erns",21,1],["at",-1,1],["andet",-1,1],["het",-1,1],["ast",-1,1]];var a=[["dd",-1,-1],["gd",-1,-1],["nn",-1,-1],["dt",-1,-1],["gt",-1,-1],["kt",-1,-1],["tt",-1,-1]];var i=[["ig",-1,1],["lig",0,1],["els",-1,1],["fullt",-1,3],["löst",-1,2]];var t=[17,65,16,1,0,0,0,0,0,0,0,0,0,0,0,0,24,0,32];var s=[119,127,149];var u=0;var n=0;function c(){n=r.limit;var e=r.cursor;{var a=r.cursor+3;if(a>r.limit){return false}r.cursor=a}u=r.cursor;r.cursor=e;r:while(true){var i=r.cursor;e:{if(!r.in_grouping(t,97,246)){break e}r.cursor=i;break r}r.cursor=i;if(r.cursor>=r.limit){return false}r.cursor++}r:while(true){e:{if(!r.out_grouping(t,97,246)){break e}break r}if(r.cursor>=r.limit){return false}r.cursor++}n=r.cursor;r:{if(!(n<u)){break r}n=u}return true}function l(){var a;if(r.cursor<n){return false}var i=r.limit_backward;r.limit_backward=n;r.ket=r.cursor;a=r.find_among_b(e);if(a==0){r.limit_backward=i;return false}r.bra=r.cursor;r.limit_backward=i;switch(a){case 1:if(!r.slice_del()){return false}break;case 2:if(!r.in_grouping_b(s,98,121)){return false}if(!r.slice_del()){return false}break}return true}function o(){if(r.cursor<n){return false}var e=r.limit_backward;r.limit_backward=n;var i=r.limit-r.cursor;if(r.find_among_b(a)==0){r.limit_backward=e;return false}r.cursor=r.limit-i;r.ket=r.cursor;if(r.cursor<=r.limit_backward){r.limit_backward=e;return false}r.cursor--;r.bra=r.cursor;if(!r.slice_del()){return false}r.limit_backward=e;return true}function f(){var e;if(r.cursor<n){return false}var a=r.limit_backward;r.limit_backward=n;r.ket=r.cursor;e=r.find_among_b(i);if(e==0){r.limit_backward=a;return false}r.bra=r.cursor;switch(e){case 1:if(!r.slice_del()){return false}break;case 2:if(!r.slice_from("lös")){return false}break;case 3:if(!r.slice_from("full")){return false}break}r.limit_backward=a;return true}this.stem=function(){var e=r.cursor;c();r.cursor=e;r.limit_backward=r.cursor;r.cursor=r.limit;var a=r.limit-r.cursor;l();r.cursor=r.limit-a;var i=r.limit-r.cursor;o();r.cursor=r.limit-i;var t=r.limit-r.cursor;f();r.cursor=r.limit-t;r.cursor=r.limit_backward;return true};this["stemWord"]=function(e){r.setCurrent(e);this.stem();return r.getCurrent()}};
Stemmer = SwedishStemmer;
